<?php
function is_logged_in() {
    return isset($_SESSION['user_id']);
}

function redirect($url) {
    header("Location: $url");
    exit();
}

function generate_token() {
    return bin2hex(random_bytes(32));
}

function validate_grade_level($grade_level) {
    return in_array($grade_level, ['1-2', '3-6']);
}

function validate_subject($subject, $grade_level) {
    $subjects_1_2 = ['Mtk', 'B.indo', 'PPKn', 'B.inggris', 'Science', 'Math', 'TIK', 
                    'Agama Islam', 'Agama Kristen', 'Agama Katolik', 'Agama Hindu', 
                    'Agama Budha', 'Agama Konghucu', 'PJOK', 'PLBJ', 'SBDP', 'Praktik Ibadah'];
    
    $subjects_3_6 = ['Mtk', 'B.indo', 'PPKn', 'IPAS', 'B.inggris', 'Science', 'Math', 'TIK', 
                    'Agama Islam', 'Agama Kristen', 'Agama Katolik', 'Agama Hindu', 
                    'Agama Budha', 'Agama Konghucu', 'PJOK', 'PLBJ', 'SBDP', 'Praktik Ibadah'];
    
    if ($grade_level == '1-2') {
        return in_array($subject, $subjects_1_2);
    } else {
        return in_array($subject, $subjects_3_6);
    }
}

function calculate_total_score($token_id, $pdo) {
    $stmt = $pdo->prepare("SELECT SUM(score) as total FROM student_answers WHERE token_id = ? AND graded = TRUE");
    $stmt->execute([$token_id]);
    return $stmt->fetchColumn() ?? 0;
}

function calculate_max_possible_score($exam_id, $pdo) {
    $stmt = $pdo->prepare("SELECT SUM(max_score) as total FROM questions WHERE exam_id = ?");
    $stmt->execute([$exam_id]);
    return $stmt->fetchColumn() ?? 0;
}
?>