<?php
require_once '../includes/config.php';
require_once '../includes/auth.php';

if ($_SESSION['role'] !== 'teacher') {
    redirect('../index.php');
}

if (!isset($_GET['exam_id'])) {
    redirect('dashboard.php');
}

$exam_id = $_GET['exam_id'];
$stmt = $pdo->prepare("SELECT * FROM exams WHERE id = ? AND teacher_id = ?");
$stmt->execute([$exam_id, $_SESSION['user_id']]);
$exam = $stmt->fetch();

if (!$exam) {
    redirect('dashboard.php');
}

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    // Handle question updates
    foreach ($_POST['questions'] as $question_id => $question_data) {
        $options = null;
        $correct_answer = null;
        
        if ($question_data['type'] == 'multiple_choice') {
            $options = json_encode($question_data['options']);
            $correct_answer = $question_data['correct_answer'];
        }
        
        $stmt = $pdo->prepare("UPDATE questions 
                              SET question_text = ?, question_type = ?, 
                                  options = ?, correct_answer = ?, max_score = ?
                              WHERE id = ? AND exam_id = ?");
        $stmt->execute([
            $question_data['text'],
            $question_data['type'],
            $options,
            $correct_answer,
            $question_data['max_score'],
            $question_id,
            $exam_id
        ]);
    }
    
    $_SESSION['success'] = "Pertanyaan berhasil diperbarui!";
    redirect("preview_exam.php?id=$exam_id");
}

$stmt = $pdo->prepare("SELECT * FROM questions WHERE exam_id = ? ORDER BY id");
$stmt->execute([$exam_id]);
$questions = $stmt->fetchAll();
?>

<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Kelola Pertanyaan - Sistem Ujian SD</title>
    <link rel="stylesheet" href="../assets/css/style.css">
</head>
<body>
    <?php include '../includes/header.php'; ?>
    
    <div class="container">
        <h1>Kelola Pertanyaan: <?php echo htmlspecialchars($exam['title']); ?></h1>
        
        <form method="POST">
            <div id="questionsContainer">
                <?php foreach ($questions as $index => $question): ?>
                    <div class="question-card" id="question_<?php echo $question['id']; ?>">
                        <div class="question-header">
                            <h3>Pertanyaan #<?php echo $index + 1; ?></h3>
                        </div>
                        
                        <div class="form-group">
                            <label>Teks Pertanyaan*</label>
                            <textarea name="questions[<?php echo $question['id']; ?>][text]" required><?php echo htmlspecialchars($question['question_text']); ?></textarea>
                        </div>
                        
                        <div class="question-type">
                            <label>
                                <input type="radio" name="questions[<?php echo $question['id']; ?>][type]" value="multiple_choice" <?php echo $question['question_type'] == 'multiple_choice' ? 'checked' : ''; ?>> Pilihan Ganda
                            </label>
                            <label>
                                <input type="radio" name="questions[<?php echo $question['id']; ?>][type]" value="essay" <?php echo $question['question_type'] == 'essay' ? 'checked' : ''; ?>> Essay
                            </label>
                        </div>
                        
                        <div class="form-group">
                            <label>Nilai Maksimal*</label>
                            <input type="number" name="questions[<?php echo $question['id']; ?>][max_score]" min="1" value="<?php echo $question['max_score']; ?>" required>
                        </div>
                        
                        <?php if ($question['question_type'] == 'multiple_choice'): ?>
                            <div class="form-group">
                                <label>Opsi Jawaban</label>
                                <div class="options-container">
                                    <?php 
                                    $options = json_decode($question['options'], true);
                                    foreach ($options as $i => $option): 
                                    ?>
                                        <div class="option-item">
                                            <input type="radio" name="questions[<?php echo $question['id']; ?>][correct_answer]" value="<?php echo $i; ?>" <?php echo $i == $question['correct_answer'] ? 'checked' : ''; ?> required>
                                            <input type="text" name="questions[<?php echo $question['id']; ?>][options][]" value="<?php echo htmlspecialchars($option); ?>" required>
                                        </div>
                                    <?php endforeach; ?>
                                </div>
                            </div>
                        <?php endif; ?>
                    </div>
                <?php endforeach; ?>
            </div>
            
            <div class="form-actions">
                <button type="submit" class="btn btn-primary">Simpan Perubahan</button>
                <a href="preview_exam.php?id=<?php echo $exam_id; ?>" class="btn btn-secondary">Kembali</a>
            </div>
        </form>
    </div>
    
    <script src="../assets/js/script.js"></script>
</body>
</html>