<?php
require_once '../includes/config.php';
require_once '../includes/auth.php';

if ($_SESSION['role'] !== 'teacher') {
    redirect('../index.php');
}

if (!isset($_GET['token_id'])) {
    redirect('dashboard.php');
}

$token_id = $_GET['token_id'];
$stmt = $pdo->prepare("SELECT st.*, e.title as exam_title, e.subject, e.grade_level
                      FROM student_tokens st
                      JOIN exams e ON e.id = st.exam_id
                      WHERE st.id = ? AND e.teacher_id = ?");
$stmt->execute([$token_id, $_SESSION['user_id']]);
$submission = $stmt->fetch();

if (!$submission) {
    redirect('dashboard.php');
}

// Get all questions for this exam
$stmt = $pdo->prepare("SELECT * FROM questions WHERE exam_id = ? ORDER BY id");
$stmt->execute([$submission['exam_id']]);
$questions = $stmt->fetchAll();

// Get all answers for this submission
$stmt = $pdo->prepare("SELECT * FROM student_answers WHERE token_id = ?");
$stmt->execute([$token_id]);
$answers = $stmt->fetchAll();

// Create a map of question_id to answer for easy access
$answer_map = [];
foreach ($answers as $answer) {
    $answer_map[$answer['question_id']] = $answer;
}

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    // Process grading
    foreach ($questions as $question) {
        if ($question['question_type'] == 'essay') {
            $score = $_POST['scores'][$question['id']] ?? 0;
            $score = max(0, min($question['max_score'], $score));
            
            if (isset($answer_map[$question['id']])) {
                // Update existing answer
                $stmt = $pdo->prepare("UPDATE student_answers 
                                      SET score = ?, graded = TRUE 
                                      WHERE id = ?");
                $stmt->execute([$score, $answer_map[$question['id']]['id']]);
            } else {
                // Insert new grading record
                $stmt = $pdo->prepare("INSERT INTO student_answers 
                                      (token_id, question_id, score, graded) 
                                      VALUES (?, ?, ?, TRUE)");
                $stmt->execute([$token_id, $question['id'], $score]);
            }
        }
    }
    
    $_SESSION['success'] = "Nilai berhasil disimpan!";
    redirect("student_answers.php?token_id=$token_id");
}
?>

<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Jawaban Siswa - Sistem Ujian SD</title>
    <link rel="stylesheet" href="../assets/css/style.css">
</head>
<body>
    <?php include '../includes/header.php'; ?>
    
    <div class="container">
        <?php if (isset($_SESSION['success'])): ?>
            <div class="alert alert-success"><?php echo $_SESSION['success']; unset($_SESSION['success']); ?></div>
        <?php endif; ?>
        
        <h1>Jawaban Siswa: <?php echo htmlspecialchars($submission['student_name']); ?></h1>
        <h2>Ujian: <?php echo htmlspecialchars($submission['exam_title']); ?></h2>
        <p>Mata Pelajaran: <?php echo htmlspecialchars($submission['subject']); ?></p>
        <p>Kelas: <?php echo htmlspecialchars($submission['grade_level']); ?></p>
        
        <form method="POST">
            <div class="student-answers">
                <?php foreach ($questions as $index => $question): ?>
                    <div class="answer-item">
                        <div class="question">
                            <h3>Pertanyaan #<?php echo $index + 1; ?></h3>
                            <p><?php echo htmlspecialchars($question['question_text']); ?></p>
                            <p>Tipe: <?php echo $question['question_type'] == 'multiple_choice' ? 'Pilihan Ganda' : 'Essay'; ?></p>
                            <p>Nilai Maks: <?php echo $question['max_score']; ?></p>
                        </div>
                        
                        <div class="answer">
                            <h4>Jawaban Siswa:</h4>
                            <?php if (isset($answer_map[$question['id']])): ?>
                                <?php if ($question['question_type'] == 'multiple_choice'): ?>
                                    <?php 
                                    $options = json_decode($question['options'], true);
                                    $selected_option = $answer_map[$question['id']]['answer'];
                                    ?>
                                    <p><?php echo htmlspecialchars($options[$selected_option] ?? 'Tidak ada jawaban'); ?></p>
                                    <p>Nilai: <?php echo ($selected_option == $question['correct_answer']) ? $question['max_score'] : 0; ?></p>
                                <?php else: ?>
                                    <p><?php echo nl2br(htmlspecialchars($answer_map[$question['id']]['answer'])); ?></p>
                                    <div class="form-group">
                                        <label for="score_<?php echo $question['id']; ?>">Nilai (0-<?php echo $question['max_score']; ?>)</label>
                                        <input type="number" id="score_<?php echo $question['id']; ?>" 
                                               name="scores[<?php echo $question['id']; ?>]" 
                                               min="0" max="<?php echo $question['max_score']; ?>" 
                                               value="<?php echo $answer_map[$question['id']]['score'] ?? 0; ?>">
                                    </div>
                                <?php endif; ?>
                            <?php else: ?>
                                <p>Siswa tidak menjawab pertanyaan ini.</p>
                                <?php if ($question['question_type'] == 'essay'): ?>
                                    <div class="form-group">
                                        <label for="score_<?php echo $question['id']; ?>">Nilai (0-<?php echo $question['max_score']; ?>)</label>
                                        <input type="number" id="score_<?php echo $question['id']; ?>" 
                                               name="scores[<?php echo $question['id']; ?>]" 
                                               min="0" max="<?php echo $question['max_score']; ?>" 
                                               value="0">
                                    </div>
                                <?php endif; ?>
                            <?php endif; ?>
                        </div>
                    </div>
                <?php endforeach; ?>
            </div>
            
            <div class="form-actions">
                <button type="submit" class="btn btn-primary">Simpan Nilai</button>
                <a href="view_results.php?id=<?php echo $submission['exam_id']; ?>" class="btn btn-secondary">Kembali</a>
            </div>
        </form>
    </div>
</body>
</html>